#! /bin/sh
#
# This script gets included by the MPICH mpirun script
# when MPICH is configured with the VIA device.
# Currently the "use_mpd" command line flag is required
# for use with MPD.
#

#######################################################################
# Copyright (C) 1999-2001 The Regents of the University of California
# (through E.O. Lawrence Berkeley National Laboratory), subject to
# approval by the U.S. Department of Energy.
#
# Your use of this software is under license -- the license agreement is
# attached and included in the MVICH top-level directory as LICENSE.TXT
# or you may contact Berkeley Lab's Technology Transfer Department at
# TTD@lbl.gov.
#
# NOTICE OF U.S. GOVERNMENT RIGHTS. The Software was developed under
# funding from the U.S. Government which consequently retains certain
# rights as follows: the U.S. Government has been granted for itself and
# others acting on its behalf a paid-up, nonexclusive, irrevocable,
# worldwide license in the Software to reproduce, prepare derivative
# works, and perform publicly and display publicly. Beginning five (5)
# years after the date permission to assert copyright is obtained from
# the U.S. Department of Energy, and subject to any subsequent five (5)
# year renewals, the U.S. Government is granted for itself and others
# acting on its behalf a paid-up, nonexclusive, irrevocable, worldwide
# license in the Software to reproduce, prepare derivative works,
# distribute copies to the public, perform publicly and display
# publicly, and to permit others to do so.
#######################################################################

default_install_machinefile=${prefix}/share/machines.${DEFAULT_ARCH}
default_util_machinefile=${datadir}/machines.${DEFAULT_ARCH}

if [ "0" = "1" ] ; then
	echo "ARCH      = $arch"
	echo "paramfile = $via_paramfile"
	echo "hostfile  = $via_hostfile"
	echo "hostlist  = $via_hostlist"
	echo "debug     = $via_debug"
	echo "totalview = $via_tv"                         /*OLG : enabled for totalview debugger*/
	echo "show      = $via_show"
	echo "xterm     = $via_xterm"
	echo "progname  = $progname"
fi

if [ "x$via_usempd" != "x" ] ; then

    via_env=""
    via_args=" -np $np"
    if [ "x$via_paramfile" != "x" ] ; then
       via_env=`$MPIRUN_BIN/read_params.pl $via_paramfile`
       if [ -n "$via_env" ] ; then
           via_env=" -MPDENV- $via_env"
       fi
    fi

    if [ "x$via_show" != "x" ]; then
	$Show mpdmpexec $via_args $progname $cmdLineArgs $via_env
    else
	eval mpdmpexec $via_args $progname $cmdLineArgs $via_env
    fi
    exitstatus=$?
else

    via_args="$via_show $via_xterm $via_debug"
    if [ "x$via_paramfile" != "x" ] ; then
       via_args="$via_args -paramfile $via_paramfile"
    fi
    via_args="$via_args -np $np"
    if [ "x$via_hostfile" = "x" ]; then
	via_hostfile="$machineFile"
    fi
    if [ "x$via_hostfile" = "x" ]; then
       if [ "x$via_hostlist" != "x" ]; then
	   via_args="$via_args $via_hostlist"
       else
	   if [ "x$PBS_NODEFILE" != "x" ]; then
	       via_args="$via_args -hostfile $PBS_NODEFILE"
	   elif [ -f "$default_install_machinefile" ]; then
	       via_args="$via_args -hostfile $default_install_machinefile"
	   elif [ -f "$default_util_machinefile" ]; then
	       via_args="$via_args -hostfile $default_util_machinefile"
           else
		echo "Need to provide machinefile or a list of machines"
		exitstatus=1
	   fi
       fi
    else
       via_args="$via_args -hostfile $via_hostfile"
    fi

    if [ "x$via_show" != "x" ]; then
	$Show $MPIRUN_HOME/mpirun_rsh $via_args $progname $cmdLineArgs
    else
	eval $MPIRUN_HOME/mpirun_rsh $via_args $progname $cmdLineArgs
    fi
    exitstatus=$?
fi
